/**
 * \file: mlink_wfd_decoder_plugin_gstbuffer.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Decoder plug-in
 *
 * \component: mlink
 *
 * \author: Ajay Kumar Sahoo ajaykumar.sahoo@in.bosch.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 Ajay Kumar Sahoo Initial version
***********************************************************************/
#ifndef _GST_WFD_BUFFER_H_
#define _GST_WFD_BUFFER_H_

#include <mlink_wfd_decoder_plugin.h>

G_BEGIN_DECLS

GType gst_wfd_buffer_get_type (void);

typedef struct _GstWfdBuffer GstWfdBuffer;
typedef struct _GstWfdBufferClass GstWfdBufferClass;

struct _GstWfdBuffer
{
    GstBuffer   buffer;
    void (*finalize)(GstWfdBuffer *buffer);

    VNCWiFiDisplayDecoder *pDecoder;
    VNCWiFiDisplayRTPPacket *pPacket;
};


struct _GstWfdBufferClass
{
    GstBufferClass klass;
};

#define GST_TYPE_WFD_BUFFER (gst_wfd_buffer_get_type())

#define GST_IS_WFD_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_WFD_BUFFER))
#define GST_WFD_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_WFD_BUFFER, GstWfdBuffer))
#define GST_WFD_BUFFER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GST_TYPE_WFD_BUFFER, GstWfdBufferClass))


G_END_DECLS
#endif /*_GST_WFD_BUFFER_H_*/
